/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build.xml;

import DE.siemens.ad.logo.model.AnalogMathsParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.ConstantBlock;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.PIDParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogMathsBlock;
import DE.siemens.ad.logo.model.block.PIDBlock;
import DE.siemens.ad.logo.model.visitor.build.Visitor;
import DE.siemens.ad.logo.model.visitor.build.xml.CompileFromXml;
import DE.siemens.ad.logo.util.ElementCodeBlock;
import DE.siemens.ad.udf.UDFBlock;
import java.util.Iterator;
import javax.help.UnsupportedOperationException;
import org.dom4j.Document;
import org.dom4j.Element;

public class CompileFromXmlLogo
extends Visitor
implements CompileFromXml {
    protected Logo fHardware;
    protected WiringDiagram fWiringDiagram;
    protected Document fDocument;

    public UDFBlock compileUDFBlock(Hardware hw, Document document) {
        throw new UnsupportedOperationException();
    }

    public WiringDiagram compile(Hardware hw, Document document) {
        this.fDocument = document;
        this.fHardware = (Logo)hw;
        this.fWiringDiagram = new WiringDiagram(hw);
        this.compileBlocks();
        return this.fWiringDiagram;
    }

    protected void compileBlocks() {
        Iterator blocksIterator = ((Element)this.fDocument.selectSingleNode("//Blocks")).elementIterator("Block");
        while (blocksIterator.hasNext()) {
            Element blockNode = (Element)blocksIterator.next();
            int opcode = Integer.valueOf(blockNode.attributeValue("opcode"));
            int blockNumber = Integer.valueOf(blockNode.attributeValue("blockNumber"));
            Block block = this.getBlock(opcode, blockNumber);
            ElementCodeBlock codeBlock = new ElementCodeBlock(this, "visit");
            codeBlock.addParameter(block);
            codeBlock.addParameter(blockNode);
            try {
                codeBlock.execMethod();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void visit(Block block, Element blockNode) {
        block.setUserDefinedName(blockNode.attributeValue("name"));
        this.connect(block, blockNode);
        this.fHardware.getParameterCompiler().compile(block, blockNode);
    }

    public void visit(ConstantBlock block, Element blockNode) {
        block.setUserDefinedName(blockNode.attributeValue("name"));
        this.connect(block, blockNode);
    }

    public void visit(AnalogMathsBlock block, Element blockNode) {
        block.setUserDefinedName(blockNode.attributeValue("name"));
        this.connect(block, blockNode);
        this.fHardware.getParameterCompiler().compile(block, blockNode);
        AnalogMathsParameter parameter = (AnalogMathsParameter)block.getParameter();
        Element paramNode = blockNode.element("Parameter");
        parameter.setEnOutputOptionID(Integer.valueOf(paramNode.element("Mode").getText()));
        Iterator operators = paramNode.element("Operators").elementIterator();
        int i = 0;
        while (operators.hasNext()) {
            Element operatorNode = (Element)operators.next();
            parameter.setOperator(i, Integer.valueOf(operatorNode.getText()));
            parameter.setOpPRI(i, Integer.valueOf(operatorNode.attributeValue("priority")));
            ++i;
        }
    }

    public void visit(PIDBlock block, Element blockNode) {
        block.setUserDefinedName(blockNode.attributeValue("name"));
        this.connect(block, blockNode);
        this.fHardware.getParameterCompiler().compile(block, blockNode);
        PIDParameter parameter = (PIDParameter)block.getParameter();
        parameter.setParameterset(Integer.valueOf(blockNode.element("Parameter").elementText("ParameterSet")));
    }

    protected Block getBlock(int opcode, int blockNumber) {
        Block result = this.fWiringDiagram.getBlock(opcode, blockNumber);
        if (result == null) {
            result = this.fWiringDiagram.createBlock(opcode, blockNumber);
        }
        return result;
    }

    protected void connect(Block source, Element blockNode) {
        Iterator connectorsNode = blockNode.elementIterator("InConnector");
        while (connectorsNode.hasNext()) {
            String opcode;
            Element connectorNode = (Element)connectorsNode.next();
            InBlockConnector inConnector = source.getInConnector(Integer.valueOf(connectorNode.attributeValue("index")));
            if (inConnector.getSignalType() != 1) {
                inConnector.setNegated(Boolean.valueOf(connectorNode.attributeValue("negate")));
            }
            if ((opcode = connectorNode.attributeValue("opcode")).equals("255")) continue;
            Block target = this.getBlock(Integer.valueOf(opcode), Integer.valueOf(connectorNode.attributeValue("blockNumber")));
            OutBlockConnector outConnector = target.getOutConnector(0);
            inConnector.connect(outConnector);
        }
    }
}

